<?php
require_once("../layouts/members/head.php");

/* =====================================
   NEW AADHAAR TO PAN LINK STATUS API
   ===================================== */
function panaadharlinkstatus_run_new($request)
{
    $aadhaar = $request['uidNumber'];
    $api_key = "APIKEYPASTEE"; // 🔥 REPLACE WITH YOUR API KEY // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )

    $url = "https://kycapizone.in/api/v2/pan_advance/aadharverify.php"
         . "?api_key={$api_key}&aadhaar_no={$aadhaar}";

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    $res = json_decode($response, true);

    // ✅ STATUS = 100 means success
    if (isset($res['status']) && (string)$res['status'] === '100') {
        return [
            'status'  => '100',
            'aadhar'  => $res['result']['aadhaar_no'] ?? '',
            'message' => $res['result']['message'] ?? $res['message'] ?? '',
            'link'    => $res['result']['link_status'] ?? '',
            'source'  => $res['result']['source'] ?? '',
        ];
    } else {
        return [
            'status' => '101',
            'error'  => $res['message'] ?? 'API Error'
        ];
    }
}

/* =====================================
   MAIN PAGE
   ===================================== */

$response = [];
$aadhaar  = '';

if ($user_data['aadhar_to_panLink_service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
<div class="col-md-4 mb-2">
<div class="card text-danger">
<div class="card-header bg-primary text-white py-2">
<div class="d-flex align-items-center">
<span class="mr-auto"><?= file_name() ?></span>
<button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
<i class="fas fa-arrow-left"></i> Back
</button>
</div>
</div>

<div class="p-3 text-dark">
<?php
if (isset($_POST['submit'])) {

    $aadhaar = is_valid_aadhaar($_POST['aadhaar']);

    if (!empty($aadhaar)) {

        $amount      = $user_data['pan_uid_status_fee'];
        $old_balance = $user_data['balance'];
        $new_balance = $old_balance - $amount;

        if ($old_balance >= $amount) {

            $order_id = order_txn_id();

            // 🔥 CALL NEW API
            $response = panaadharlinkstatus_run_new([
                'uidNumber' => $aadhaar,
                'order_id'  => $order_id
            ]);

            if (isset($response['status']) && $response['status'] == '100') {

                // WALLET UPDATE
                db_update(
                    "members",
                    ["balance" => $new_balance],
                    " user_id='{$user_data['user_id']}' "
                );

                // REPORT ENTRY
                db_insert("reports", [
                    'site_id'        => $site_data['site_id'],
                    'user_id'        => $user_data['user_id'],
                    'username'       => $user_data['username'],
                    'name'           => $user_data['name'],
                    'operator'       => $user_data['usertype'],
                    'parent_id'      => $user_data['parent_id'],
                    'order_id'       => $order_id,
                    'service'        => "PAN UID LINK STATUS",
                    'type'           => "Debit",
                    'account_number' => $aadhaar,
                    'app_type'       => "PAN UID LINK STATUS",
                    'amount'         => $amount,
                    'main_amount'    => $amount,
                    'old_balance'    => $old_balance,
                    'new_balance'    => $new_balance,
                    'txn_id'         => $order_id,
                    'ref_id'         => $response['message'],
                    'description'    => "Rs.{$amount} Debited for Aadhaar {$aadhaar} PAN Link Status",
                    'date_time'      => current_timestamp(),
                    'status'         => "Success"
                ]);

                // SMS
                $whamessage = "Dear {$user_data['name']},\n"
                            . "Aadhaar No: *{$aadhaar}*\n"
                            . "Status: *{$response['message']}*\n\n"
                            . "_*{$site_data['brand']}*_";

                send_sms($user_data['mobile'], $whamessage);

            } else {
                awal_alert_msg($response['error'], 'error');
            }

        } else {
            awal_alert_msg("Insufficient Wallet Balance!", 'error');
        }
    } else {
        awal_alert_msg("Invalid Aadhaar Number!", 'error');
    }
}
?>

<form method="POST" class="row">
<div class="col-md-12 mb-3">
<label>Aadhaar Number</label>
<input type="number" name="aadhaar"
maxlength="12"
class="form-control"
onkeypress="if(this.value.length==12) return false;"
required>
</div>

<div class="col-md-12 mb-3 d-flex justify-content-between">
<button type="button" class="btn btn-secondary">
<i class="fas fa-inr"></i> <?= $user_data['pan_find_fee']; ?>
</button>

<button type="submit" name="submit"
class="btn btn-primary"
onclick="return confirm('Are you sure?');">
Submit
</button>

<button type="button" class="btn btn-warning"
data-toggle="modal" data-target="#showDetailsModal">
Show
</button>
</div>
</form>
</div>
</div>
</div>
</div>

<!-- ================= MODAL ================= -->
<div class="modal fade" id="showDetailsModal">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Fetched Details</h5>
<button class="close" data-dismiss="modal">&times;</button>
</div>

<div class="modal-body">
<?php if (!empty($response['message'])) { ?>
<input class="form-control mb-2" value="<?= htmlspecialchars($aadhaar) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['message']) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['link']) ?>" readonly>
<?php } else { ?>
<p>No details fetched yet.</p>
<?php } ?>
</div>

<div class="modal-footer">
<button class="btn btn-danger" data-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>

<script>
<?php if (!empty($response['message'])) { ?>
$(document).ready(function(){
    $('#showDetailsModal').modal('show');
});
<?php } ?>
</script>

<?php
} else {
require_once("404.php");
}
} else {
awal_alert_msg('You Do Not Have Any PAN Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>
